<?php

namespace App\Constants;

class MarketInfo {

    public function marketInfo() {
        return [
            [
                'key'                => 'h2h',
                'name'               => 'Moneyline',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 0,
                'player_props'       => 0,
                'description'        => 'Bet on the winning team',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'spreads',
                'name'               => 'Spreads',
                'outcome_type'       => Status::SPREAD_POINT,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 0,
                'player_props'       => 0,
                'description'        => 'Bet on the winning team after a points handicap has been applied to each team',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'totals',
                'name'               => 'Totals',
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 0,
                'player_props'       => 0,
                'description'        => 'Bet on the total score of the game being above or below a threshold',
                'max_limit'          => 1, //Infinity
            ],
            [
                'key'                => 'outrights',
                'name'               => 'Outrights',
                'outcome_type'       => Status::ODDS_ONLY,
                'need_market_title'  => true,
                'outcomes'           => [], // Infinity
                'game_period_market' => 0,
                'player_props'       => 0,
                'description'        => 'Bet on a final outcome of a tournament or competition',
            ],
            [
                'key'                => 'h2h_3way',
                'name'               => 'Moneyline 3 Way',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'Draw', 'team_two'],
                'game_period_market' => 0,
                'player_props'       => 0,
                'description'        => 'Match winner including draw',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'toss_winner', // custom
                'name' => 'Toss Winner',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 0,
                'player_props'       => 0,
                'description'        => 'Bet on the winning team',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'draw_no_bet',
                'name'               => 'Draw no bet',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 0,
                'player_props'       => 0,
                'description'        => 'Bet on the winner, excluding the possibility of a draw',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'btts',
                'name'               => 'Both Teams to Score',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['Yes', 'No'],
                'game_period_market' => 0,
                'player_props'       => 0,
                'description'        => 'Bet on whether both teams will score during the game',
                'max_limit'          => 1,
                'sports'             => ['soccer'],
            ],
            [
                'key'                => 'team_totals',
                'name'               => 'Team Totals',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 0,
                'player_props'       => 0,
                'description'        => 'Bet on a team\'s total score going over or under a given line',
                'max_limit'          => 2,
            ],
            [
                'key'                => 'team_first_score', // custom
                'name'               => 'First Team to Score',
                'outcomes'           => ['team_one', 'team_two'],
                'outcome_type'       => Status::ODDS_ONLY,
                'game_period_market' => 0,
                'player_props'       => 0,
                'description'        => 'Bet on which team will score first',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'exact_score', // custom
                'name'               => 'Exact Combine Score of The Game',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => [], // Infinity
                'game_period_market' => 0,
                'player_props'       => 0,
                'description'        => 'Bet on the exact final score of the game',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'h2h_q1',
                'name'               => 'Moneyline 1st Quarter',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the winner of the 1st quarter',
                'max_limit'          => 1,
                'sports'             => ['American Football', 'Basketball', 'Aussie Rules', 'Canadian Football', 'Lacrosse'],
            ],
            [
                'key'                => 'h2h_q2',
                'name'               => 'Moneyline 2nd Quarter',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the winner of the 2nd quarter',
                'max_limit'          => 1,
                'sports'             => ['American Football', 'Basketball', 'Aussie Rules', 'Canadian Football', 'Lacrosse'],
            ],
            [
                'key'                => 'h2h_q3',
                'name'               => 'Moneyline 3rd Quarter',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the winner of the 3rd quarter',
                'max_limit'          => 1,
                'sports'             => ['American Football', 'Basketball', 'Aussie Rules', 'Canadian Football', 'Lacrosse'],
            ],
            [
                'key'                => 'h2h_q4',
                'name'               => 'Moneyline 4th Quarter',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the winner of the 4th quarter',
                'max_limit'          => 1,
                'sports'             => ['American Football', 'Basketball', 'Aussie Rules', 'Canadian Football', 'Lacrosse'],
            ],
            [
                'key'                => 'h2h_h1',
                'name'               => 'Moneyline 1st Half',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the winner of the 1st half',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'h2h_h2',
                'name'               => 'Moneyline 2nd Half',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the winner of the 2nd half',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'h2h_p1',
                'name'               => 'Moneyline 1st Period',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the winner of the 1st period',
                'max_limit'          => 1,
                'sports'             => ['Ice Hockey'],
            ],
            [
                'key'                => 'h2h_p2',
                'name'               => 'Moneyline 2nd Period',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the winner of the 2nd period',
                'max_limit'          => 1,
                'sports'             => ['Ice Hockey'],
            ],
            [
                'key'                => 'h2h_p3',
                'name'               => 'Moneyline 3rd Period',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the winner of the 3rd period',
                'max_limit'          => 1,
                'sports'             => ['Ice Hockey'],
            ],
            [
                'key'                => 'h2h_1st_1_innings',
                'name'               => 'Moneyline 1st inning',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the winner of the 1st inning',
                'max_limit'          => 1,
                'sports'             => ['Baseball'],
            ],
            [
                'key'                => 'h2h_1st_3_innings',
                'name'               => 'Moneyline 1st 3 innings',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on which team will win during the first 3 innings of the game',
                'max_limit'          => 1,
                'sports'             => ['Baseball'],
            ],
            [
                'key'                => 'h2h_1st_5_innings',
                'name'               => 'Moneyline 1st 5 innings',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on which team will win during the first 5 innings of the game',
                'max_limit'          => 1,
                'sports'             => ['Baseball'],
            ],
            [
                'key'                => 'h2h_1st_7_innings',
                'name'               => 'Moneyline 1st 7 innings',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on which team will win during the first 3 innings of the game',
                'max_limit'          => 1,
                'sports'             => ['Baseball'],
            ],
            [
                'key'                => 'h2h_3_way_1st_1_innings',
                'name'               => '3-way moneyline 1st inning',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'Draw', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on which team will win the first inning or if it will end in a draw',
                'max_limit'          => 1,
                'sports'             => ['Baseball'],
            ],
            [
                'key'                => 'h2h_3_way_1st_3_innings',
                'name'               => '3-way moneyline 1st 3 innings',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'Draw', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the winning team or a draw in the first 3 innings of play',
                'max_limit'          => 1,
                'sports'             => ['Baseball'],
            ],
            [
                'key'                => 'h2h_3_way_1st_5_innings',
                'name'               => '3-way moneyline 1st 5 innings',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'Draw', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the winning team or a draw in the first 5 innings of play',
                'max_limit'          => 1,
                'sports'             => ['Baseball'],
            ],
            [
                'key'                => 'h2h_3_way_1st_7_innings',
                'name'               => '3-way moneyline 1st 5 innings',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['team_one', 'Draw', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the winning team or a draw in the first 7 innings of play',
                'max_limit'          => 1,
                'sports'             => ['Baseball'],
            ],
            [
                'key'                => 'spreads_q1',
                'name'               => 'Spreads 1st Quarter',
                'outcome_type'       => Status::SPREAD_POINT,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the point spread for the first quarter of the game',
                'max_limit'          => 1,
                'sports'             => ['American Football', 'Basketball', 'Aussie Rules', 'Canadian Football', 'Lacrosse'],
            ],
            [
                'key'                => 'spreads_q2',
                'name'               => 'Spreads 2nd Quarter',
                'outcome_type'       => Status::SPREAD_POINT,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the point spread for the second quarter of the game',
                'max_limit'          => 1,
                'sports'             => ['American Football', 'Basketball', 'Aussie Rules', 'Canadian Football', 'Lacrosse'],
            ],
            [
                'key'                => 'spreads_q3',
                'name'               => 'Spreads 3rd Quarter',
                'outcome_type'       => Status::SPREAD_POINT,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the point spread for the third quarter of the game',
                'max_limit'          => 1,
                'sports'             => ['American Football', 'Basketball', 'Aussie Rules', 'Canadian Football', 'Lacrosse'],
            ],
            [
                'key'                => 'spreads_q4',
                'name'               => 'Spreads 4th Quarter',
                'outcome_type'       => Status::SPREAD_POINT,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the point spread for the fourth quarter of the game',
                'max_limit'          => 1,
                'sports'             => ['American Football', 'Basketball', 'Aussie Rules', 'Canadian Football', 'Lacrosse'],
            ],
            [
                'key'                => 'spreads_h1',
                'name'               => 'Spreads 1st Half',
                'outcome_type'       => Status::SPREAD_POINT,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the point spread for the first half of the match',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'spreads_h2',
                'name'               => 'Spreads 2nd Half',
                'outcome_type'       => Status::SPREAD_POINT,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the point spread for the second half of the match',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'spreads_p1',
                'name'               => 'Spreads 1st Period',
                'outcome_type'       => Status::SPREAD_POINT,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the point spread for the first period',
                'max_limit'          => 1,
                'sports'             => ['Ice Hockey'],
            ],
            [
                'key'                => 'spreads_p2',
                'name'               => 'Spreads 2nd Period',
                'outcome_type'       => Status::SPREAD_POINT,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the point spread for the second period',
                'max_limit'          => 1,
                'sports'             => ['Ice Hockey'],
            ],
            [
                'key'                => 'spreads_p3',
                'name'               => 'Spreads 3rd Period',
                'outcome_type'       => Status::SPREAD_POINT,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the point spread for the 3rd period',
                'max_limit'          => 1,
                'sports'             => ['Ice Hockey'],
            ],
            [
                'key'                => 'spreads_1st_1_innings',
                'name'               => 'Spreads 1st inning',
                'outcome_type'       => Status::SPREAD_POINT,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the point spread for the first inning of play',
                'max_limit'          => 1,
                'sports'             => ['Baseball'],
            ],
            [
                'key'                => 'spreads_1st_3_innings',
                'name'               => 'Spreads 1st 3 innings',
                'outcome_type'       => Status::SPREAD_POINT,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the point spread for the firs 3 innings of play',
                'max_limit'          => 1,
                'sports'             => ['Baseball'],
            ],
            [
                'key'                => 'spreads_1st_5_innings',
                'name'               => 'Spreads 1st 5 innings',
                'outcome_type'       => Status::SPREAD_POINT,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the point spread for the first 5 innings of play',
                'max_limit'          => 1,
                'sports'             => ['Baseball'],
            ],
            [
                'key'                => 'spreads_1st_7_innings',
                'name'               => 'Spreads 1st 7 innings',
                'outcome_type'       => Status::SPREAD_POINT,
                'outcomes'           => ['team_one', 'team_two'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the point spread for the first 7 innings of play',
                'max_limit'          => 1,
                'sports'             => ['Baseball'],
            ],
            [
                'key'                => 'totals_q1',
                'name'               => 'Over/under 1st Quarter',
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the total score of the 1st quarter of the game being above or below a threshold',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'totals_q2',
                'name'               => 'Over/under 2nd Quarter',
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the total score of the 2nd quarter of the game being above or below a threshold',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'totals_q3',
                'name'               => 'Over/under 3rd Quarter',
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the total score of the 3rd quarter of the game being above or below a threshold',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'totals_q4',
                'name'               => 'Over/under 4th Quarter',
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the total score of the 4th quarter of the game being above or below a threshold',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'totals_h1',
                'name'               => 'Over/under 1st Half',
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the total score of the 1st half of the game being above or below a threshold',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'totals_h2',
                'name'               => 'Over/under 2nd Half',
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the total score of the 2nd half of the game being above or below a threshold',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'totals_p1',
                'name'               => 'Over/under 1st Period',
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the total score of the 1st period of the game being above or below a threshold',
                'max_limit'          => 1,
                'sports'             => ['Ice Hockey'],
            ],
            [
                'key'                => 'totals_p2',
                'name'               => 'Over/under 2nd Period',
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the total score of the 2nd period of the game being above or below a threshold',
                'max_limit'          => 1,
                'sports'             => ['Ice Hockey'],
            ],
            [
                'key'                => 'totals_p3',
                'name'               => 'Over/under 3rd Period',
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the total score of the 3rd period of the game being above or below a threshold',
                'max_limit'          => 1,
                'sports'             => ['Ice Hockey'],
            ],
            [
                'key'                => 'totals_1st_1_innings',
                'name'               => 'Over/under 1st inning',
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the total score of the 1st inning of the game being above or below a threshold',
                'max_limit'          => 1,
                'sports'             => ['Baseball'],
            ],
            [
                'key'                => 'totals_1st_3_innings',
                'name'               => 'Over/under 1st 3 innings',
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the total score of the 1st 3 innings of the game being above or below a threshold',
                'max_limit'          => 1,
                'sports'             => ['Baseball'],
            ],
            [
                'key'                => 'totals_1st_5_innings',
                'name'               => 'Over/under 1st 5 innings',
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the total score of the 1st 5 innings of the game being above or below a threshold',
                'max_limit'          => 1,
                'sports'             => ['Baseball'],
            ],
            [
                'key'                => 'totals_1st_7_innings',
                'name'               => 'Over/under 1st 7 innings',
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on the total score of the 1st 7 innings of the game being above or below a threshold',
                'max_limit'          => 1,
                'sports'             => ['Baseball'],
            ],
            [
                'key'                => 'team_totals_h1',
                'name'               => 'Team Totals H1',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on a team\'s total score of first half over or under a given line',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'team_totals_h2',
                'name'               => 'Team Totals H2',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on a team\'s total score of 2nd half over or under a given line',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'team_totals_q1',
                'name'               => 'Team Totals Q1',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on a team\'s total score of 1st quarter over or under a given line',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'team_totals_q2',
                'name'               => 'Team Totals Q2',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on a team\'s total score of 2nd quarter over or under a given line',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'team_totals_q3',
                'name'               => 'Team Totals Q3',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on a team\'s total score of 3rd quarter over or under a given line',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'team_totals_q4',
                'name'               => 'Team Totals Q4',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 0,
                'description'        => 'Bet on a team\'s total score of 4th quarter over or under a given line',
                'max_limit'          => 1,
            ],
            [
                'key'                => 'player_assists',
                'name'               => 'Player Assists',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 1,
                'description'        => 'Number of assists a player will record in the game',
                'max_limit'          => -1, //Infinity
                'sports'             => ['Soccer', 'American Football'],
            ],
            [
                'key'                => 'player_field_goals',
                'name'               => 'Field Goals',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 1,
                'description'        => 'Number of goals by a player will scored in the game',
                'max_limit'          => -1, //Infinity
                'sports'             => ['Basketball', 'American Football'],
            ],




            [
                'key'                => 'player_total_points',
                'name'               => 'Total Points',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 1,
                'description'        => 'Total points a player will score in the game',
                'max_limit'          => -1, // Infinity
            ],
            [
                'key'                => 'player_rebounds',
                'name'               => 'Total Rebounds',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 1,
                'description'        => 'Total rebounds a player will grab in the game',
                'max_limit'          => -1, // Infinity
                'sports'             => ['Basketball'],
            ],
            [
                'key'                => 'player_three_pointers',
                'name'               => 'Three Pointers Made',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 1,
                'description'        => 'Total three-pointers a player will make in the game',
                'max_limit'          => -1, // Infinity
                'sports'             => ['Basketball'],
            ],
            [
                'key'                => 'player_touchdowns',
                'name'               => 'Total Touchdowns',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 1,
                'description'        => 'Total touchdowns a player will score in the game',
                'max_limit'          => -1, // Infinity
                'sports'             => ['American Football'],
            ],
            [
                'key'                => 'player_sacks',
                'name'               => 'Total Sacks',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 1,
                'description'        => 'Total sacks a defensive player will record in the game',
                'max_limit'          => -1, // Infinity
                'sports'             => ['American Football'],
            ],
            [
                'key'                => 'player_home_runs',
                'name'               => 'Total Home Runs',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 1,
                'description'        => 'Total home runs a player will hit in the game',
                'max_limit'          => -1, // Infinity
                'sports'             => ['Baseball'],
            ],
            [
                'key'                => 'player_strikeouts',
                'name'               => 'Total Strikeouts',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 1,
                'description'        => 'Total strikeouts a pitcher will throw in the game',
                'max_limit'          => -1, // Infinity
                'sports'             => ['Baseball'],
            ],
            [
                'key'                => 'player_shots_on_target',
                'name'               => 'Shots on Target',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 1,
                'description'        => 'Total shots on target a player will have in the game',
                'max_limit'          => -1, // Infinity
                'sports'             => ['Soccer'],
            ],
            [
                'key'                => 'player_saves',
                'name'               => 'Total Saves',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 1,
                'description'        => 'Total saves a goalkeeper will make in the game',
                'max_limit'          => -1, // Infinity
                'sports'             => ['Soccer'],
            ],
            [
                'key'                => 'player_interceptions',
                'name'               => 'Total Interceptions',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 1,
                'description'        => 'Total interceptions a defensive player will record in the game',
                'max_limit'          => -1, // Infinity
                'sports'             => ['American Football', 'Soccer'],
            ],
            [
                'key'                => 'player_penalty_minutes',
                'name'               => 'Penalty Minutes',
                'need_market_title'  => true,
                'outcome_type'       => Status::OVER_UNDER,
                'outcomes'           => ['Over', 'Under'],
                'game_period_market' => 1,
                'player_props'       => 1,
                'description'        => 'Total penalty minutes a player will receive in the game',
                'max_limit'          => -1, // Infinity
                'sports'             => ['Hockey'],
            ],
            [
                'key'                => 'player_first_goal',
                'name'               => 'First Goal Scorer',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => [], // Open-ended
                'game_period_market' => 1,
                'player_props'       => 1,
                'description'        => 'Which player will score the first goal of the game',
                'max_limit'          => -1,
                'sports'             => ['Soccer', 'Hockey'],
            ],
            [
                'key'                => 'player_double_double',
                'name'               => 'Double-Double',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['Yes', 'No'],
                'game_period_market' => 1,
                'player_props'       => 1,
                'description'        => 'Will the player record a double-double in the game?',
                'max_limit'          => -1,
                'sports'             => ['Basketball'],
            ],
            [
                'key'                => 'player_triple_double',
                'name'               => 'Triple-Double',
                'outcome_type'       => Status::ODDS_ONLY,
                'outcomes'           => ['Yes', 'No'],
                'game_period_market' => 1,
                'player_props'       => 1,
                'description'        => 'Will the player record a triple-double in the game?',
                'max_limit'          => -1,
                'sports'             => ['Basketball'],
            ],
        ];
    }
}
