let ICONS = [
     {
          "icon": "fas fa-whistle",
          "name": "whistle"
     },
     {
          "icon": "fas fa-volleyball-ball",
          "name": "volleyball-ball"
     },
     {
          "icon": "fas fa-tennis-ball",
          "name": "tennis-ball"
     },
     {
          "icon": "fas fa-table-tennis",
          "name": "table-tennis"
     },
     {
          "icon": "fas fa-swimmer",
          "name": "swimmer"
     },
     {
          "icon": "fas fa-snowboarding",
          "name": "snowboarding"
     },
     {
          "icon": "fas fa-sledding",
          "name": "sledding"
     },
     {
          "icon": "fas fa-skiing-nordic",
          "name": "skiing-nordic"
     },
     {
          "icon": "fas fa-skiing",
          "name": "skiing"
     },
     {
          "icon": "fas fa-ski-jump",
          "name": "ski-jump"
     },
     {
          "icon": "fas fa-skating",
          "name": "skating"
     },
     {
          "icon": "fas fa-shuttlecock",
          "name": "shuttlecock"
     },
     {
          "icon": "fas fa-running",
          "name": "running"
     },
     {
          "icon": "fas fa-racquet",
          "name": "racquet"
     },
     {
          "icon": "fas fa-quidditch",
          "name": "quidditch"
     },
     {
          "icon": "fas fa-pennant",
          "name": "pennant"
     },
     {
          "icon": "fas fa-luchador",
          "name": "luchador"
     },
     {
          "icon": "fas fa-ice-skate",
          "name": "ice-skate"
     },
     {
          "icon": "fas fa-hockey-sticks",
          "name": "hockey-sticks"
     },
     {
          "icon": "fas fa-hockey-puck",
          "name": "hockey-puck"
     },
     {
          "icon": "fas fa-hockey-mask",
          "name": "hockey-mask"
     },
     {
          "icon": "fas fa-golf-club",
          "name": "golf-club"
     },
     {
          "icon": "fas fa-golf-ball",
          "name": "golf-ball"
     },
     {
          "icon": "fas fa-futbol",
          "name": "futbol"
     },
     {
          "icon": "fas fa-football-helmet",
          "name": "football-helmet"
     },
     {
          "icon": "fas fa-football-ball",
          "name": "football-ball"
     },
     {
          "icon": "fas fa-field-hockey",
          "name": "field-hockey"
     },
     {
          "icon": "fas fa-dumbbell",
          "name": "dumbbell"
     },
     {
          "icon": "fas fa-curling",
          "name": "curling"
     },
     {
          "icon": "fas fa-cricket",
          "name": "cricket"
     },
     {
          "icon": "fas fa-boxing-glove",
          "name": "boxing-glove"
     },
     {
          "icon": "fas fa-bowling-pins",
          "name": "bowling-pins"
     },
     {
          "icon": "fas fa-bowling-ball",
          "name": "bowling-ball"
     },
     {
          "icon": "fas fa-biking-mountain",
          "name": "biking-mountain"
     },
     {
          "icon": "fas fa-biking",
          "name": "biking"
     },
     {
          "icon": "fas fa-basketball-hoop",
          "name": "basketball-hoop"
     },
     {
          "icon": "fas fa-basketball-ball",
          "name": "basketball-ball"
     },
     {
          "icon": "fas fa-baseball-ball",
          "name": "baseball-ball"
     },
     {
          "icon": "fas fa-baseball",
          "name": "baseball"
     },
     {
          "icon": "far fa-whistle",
          "name": "whistle"
     },
     {
          "icon": "far fa-volleyball-ball",
          "name": "volleyball-ball"
     },
     {
          "icon": "far fa-tennis-ball",
          "name": "tennis-ball"
     },
     {
          "icon": "far fa-table-tennis",
          "name": "table-tennis"
     },
     {
          "icon": "far fa-swimmer",
          "name": "swimmer"
     },
     {
          "icon": "far fa-snowboarding",
          "name": "snowboarding"
     },
     {
          "icon": "far fa-sledding",
          "name": "sledding"
     },
     {
          "icon": "far fa-skiing-nordic",
          "name": "skiing-nordic"
     },
     {
          "icon": "far fa-skiing",
          "name": "skiing"
     },
     {
          "icon": "far fa-ski-jump",
          "name": "ski-jump"
     },
     {
          "icon": "far fa-skating",
          "name": "skating"
     },
     {
          "icon": "far fa-shuttlecock",
          "name": "shuttlecock"
     },
     {
          "icon": "far fa-running",
          "name": "running"
     },
     {
          "icon": "far fa-racquet",
          "name": "racquet"
     },
     {
          "icon": "far fa-quidditch",
          "name": "quidditch"
     },
     {
          "icon": "far fa-pennant",
          "name": "pennant"
     },
     {
          "icon": "far fa-luchador",
          "name": "luchador"
     },
     {
          "icon": "far fa-ice-skate",
          "name": "ice-skate"
     },
     {
          "icon": "far fa-hockey-sticks",
          "name": "hockey-sticks"
     },
     {
          "icon": "far fa-hockey-puck",
          "name": "hockey-puck"
     },
     {
          "icon": "far fa-hockey-mask",
          "name": "hockey-mask"
     },
     {
          "icon": "far fa-golf-club",
          "name": "golf-club"
     },
     {
          "icon": "far fa-golf-ball",
          "name": "golf-ball"
     },
     {
          "icon": "far fa-futbol",
          "name": "futbol"
     },
     {
          "icon": "far fa-football-helmet",
          "name": "football-helmet"
     },
     {
          "icon": "far fa-football-ball",
          "name": "football-ball"
     },
     {
          "icon": "far fa-field-hockey",
          "name": "field-hockey"
     },
     {
          "icon": "far fa-dumbbell",
          "name": "dumbbell"
     },
     {
          "icon": "far fa-curling",
          "name": "curling"
     },
     {
          "icon": "far fa-cricket",
          "name": "cricket"
     },
     {
          "icon": "far fa-boxing-glove",
          "name": "boxing-glove"
     },
     {
          "icon": "far fa-bowling-pins",
          "name": "bowling-pins"
     },
     {
          "icon": "far fa-bowling-ball",
          "name": "bowling-ball"
     },
     {
          "icon": "far fa-biking-mountain",
          "name": "biking-mountain"
     },
     {
          "icon": "far fa-biking",
          "name": "biking"
     },
     {
          "icon": "far fa-basketball-hoop",
          "name": "basketball-hoop"
     },
     {
          "icon": "far fa-basketball-ball",
          "name": "basketball-ball"
     },
     {
          "icon": "far fa-baseball-ball",
          "name": "baseball-ball"
     },
     {
          "icon": "far fa-baseball",
          "name": "baseball"
     },
     {
          "icon": "fal fa-whistle",
          "name": "whistle"
     },
     {
          "icon": "fal fa-volleyball-ball",
          "name": "volleyball-ball"
     },
     {
          "icon": "fal fa-tennis-ball",
          "name": "tennis-ball"
     },
     {
          "icon": "fal fa-table-tennis",
          "name": "table-tennis"
     },
     {
          "icon": "fal fa-swimmer",
          "name": "swimmer"
     },
     {
          "icon": "fal fa-snowboarding",
          "name": "snowboarding"
     },
     {
          "icon": "fal fa-sledding",
          "name": "sledding"
     },
     {
          "icon": "fal fa-skiing-nordic",
          "name": "skiing-nordic"
     },
     {
          "icon": "fal fa-skiing",
          "name": "skiing"
     },
     {
          "icon": "fal fa-ski-jump",
          "name": "ski-jump"
     },
     {
          "icon": "fal fa-skating",
          "name": "skating"
     },
     {
          "icon": "fal fa-shuttlecock",
          "name": "shuttlecock"
     },
     {
          "icon": "fal fa-running",
          "name": "running"
     },
     {
          "icon": "fal fa-racquet",
          "name": "racquet"
     },
     {
          "icon": "fal fa-quidditch",
          "name": "quidditch"
     },
     {
          "icon": "fal fa-pennant",
          "name": "pennant"
     },
     {
          "icon": "fal fa-luchador",
          "name": "luchador"
     },
     {
          "icon": "fal fa-ice-skate",
          "name": "ice-skate"
     },
     {
          "icon": "fal fa-hockey-sticks",
          "name": "hockey-sticks"
     },
     {
          "icon": "fal fa-hockey-puck",
          "name": "hockey-puck"
     },
     {
          "icon": "fal fa-hockey-mask",
          "name": "hockey-mask"
     },
     {
          "icon": "fal fa-golf-club",
          "name": "golf-club"
     },
     {
          "icon": "fal fa-golf-ball",
          "name": "golf-ball"
     },
     {
          "icon": "fal fa-futbol",
          "name": "futbol"
     },
     {
          "icon": "fal fa-football-helmet",
          "name": "football-helmet"
     },
     {
          "icon": "fal fa-football-ball",
          "name": "football-ball"
     },
     {
          "icon": "fal fa-field-hockey",
          "name": "field-hockey"
     },
     {
          "icon": "fal fa-dumbbell",
          "name": "dumbbell"
     },
     {
          "icon": "fal fa-curling",
          "name": "curling"
     },
     {
          "icon": "fal fa-cricket",
          "name": "cricket"
     },
     {
          "icon": "fal fa-boxing-glove",
          "name": "boxing-glove"
     },
     {
          "icon": "fal fa-bowling-pins",
          "name": "bowling-pins"
     },
     {
          "icon": "fal fa-bowling-ball",
          "name": "bowling-ball"
     },
     {
          "icon": "fal fa-biking-mountain",
          "name": "biking-mountain"
     },
     {
          "icon": "fal fa-biking",
          "name": "biking"
     },
     {
          "icon": "fal fa-basketball-hoop",
          "name": "basketball-hoop"
     },
     {
          "icon": "fal fa-basketball-ball",
          "name": "basketball-ball"
     },
     {
          "icon": "fal fa-baseball-ball",
          "name": "baseball-ball"
     },
     {
          "icon": "fal fa-baseball",
          "name": "baseball"
     },
     {
          "icon": "fad fa-whistle",
          "name": "whistle"
     },
     {
          "icon": "fad fa-volleyball-ball",
          "name": "volleyball-ball"
     },
     {
          "icon": "fad fa-tennis-ball",
          "name": "tennis-ball"
     },
     {
          "icon": "fad fa-table-tennis",
          "name": "table-tennis"
     },
     {
          "icon": "fad fa-swimmer",
          "name": "swimmer"
     },
     {
          "icon": "fad fa-snowboarding",
          "name": "snowboarding"
     },
     {
          "icon": "fad fa-sledding",
          "name": "sledding"
     },
     {
          "icon": "fad fa-skiing-nordic",
          "name": "skiing-nordic"
     },
     {
          "icon": "fad fa-skiing",
          "name": "skiing"
     },
     {
          "icon": "fad fa-ski-jump",
          "name": "ski-jump"
     },
     {
          "icon": "fad fa-skating",
          "name": "skating"
     },
     {
          "icon": "fad fa-shuttlecock",
          "name": "shuttlecock"
     },
     {
          "icon": "fad fa-running",
          "name": "running"
     },
     {
          "icon": "fad fa-racquet",
          "name": "racquet"
     },
     {
          "icon": "fad fa-quidditch",
          "name": "quidditch"
     },
     {
          "icon": "fad fa-pennant",
          "name": "pennant"
     },
     {
          "icon": "fad fa-luchador",
          "name": "luchador"
     },
     {
          "icon": "fad fa-ice-skate",
          "name": "ice-skate"
     },
     {
          "icon": "fad fa-hockey-sticks",
          "name": "hockey-sticks"
     },
     {
          "icon": "fad fa-hockey-puck",
          "name": "hockey-puck"
     },
     {
          "icon": "fad fa-hockey-mask",
          "name": "hockey-mask"
     },
     {
          "icon": "fad fa-golf-club",
          "name": "golf-club"
     },
     {
          "icon": "fad fa-golf-ball",
          "name": "golf-ball"
     },
     {
          "icon": "fad fa-futbol",
          "name": "futbol"
     },
     {
          "icon": "fad fa-football-helmet",
          "name": "football-helmet"
     },
     {
          "icon": "fad fa-football-ball",
          "name": "football-ball"
     },
     {
          "icon": "fad fa-field-hockey",
          "name": "field-hockey"
     },
     {
          "icon": "fad fa-dumbbell",
          "name": "dumbbell"
     },
     {
          "icon": "fad fa-curling",
          "name": "curling"
     },
     {
          "icon": "fad fa-cricket",
          "name": "cricket"
     },
     {
          "icon": "fad fa-boxing-glove",
          "name": "boxing-glove"
     },
     {
          "icon": "fad fa-bowling-pins",
          "name": "bowling-pins"
     },
     {
          "icon": "fad fa-bowling-ball",
          "name": "bowling-ball"
     },
     {
          "icon": "fad fa-biking-mountain",
          "name": "biking-mountain"
     },
     {
          "icon": "fad fa-biking",
          "name": "biking"
     },
     {
          "icon": "fad fa-basketball-hoop",
          "name": "basketball-hoop"
     },
     {
          "icon": "fad fa-basketball-ball",
          "name": "basketball-ball"
     },
     {
          "icon": "fad fa-baseball-ball",
          "name": "baseball-ball"
     },
     {
          "icon": "fad fa-baseball",
          "name": "baseball"
     },
     {
          "icon": "fad fa-bullseye-arrow",
          "name": "dart"
     },
     {
          "icon": "far fa-bullseye-arrow",
          "name": "dart"
     },
     {
          "icon": "fal fa-bullseye-arrow",
          "name": "dart"
     },
     {
          "icon": "custom-icon american-football",
          "name": "american-football"
     },
     {
          "icon": "custom-icon baccarat",
          "name": "baccarat"
     },
     {
          "icon": "custom-icon badminton",
          "name": "badminton"
     },
     {
          "icon": "custom-icon baseball",
          "name": "baseball"
     },
     {
          "icon": "custom-icon basketball",
          "name": "basketball"
     },
     {
          "icon": "custom-icon battleships",
          "name": "battleships"
     },
     {
          "icon": "custom-icon beach-volleyball",
          "name": "beach-volleyball"
     },
     {
          "icon": "custom-icon boat-racing",
          "name": "boat-racing"
     },
     {
          "icon": "custom-icon card-football",
          "name": "card-football"
     },
     {
          "icon": "custom-icon cricket",
          "name": "cricket"
     },
     {
          "icon": "custom-icon golf",
          "name": "golf"
     },
     {
          "icon": "custom-icon horse-racing",
          "name": "horse-racing"
     },
     {
          "icon": "custom-icon ice-hockey",
          "name": "ice-hockey"
     },
     {
          "icon": "custom-icon lacrosse",
          "name": "lacrosse"
     },
     {
          "icon": "custom-icon mixed-martial-arts	",
          "name": "mixed-martial-arts"
     },
     {
          "icon": "custom-icon politics",
          "name": "politics"
     },
     {
          "icon": "custom-icon rugby-league",
          "name": "rugby"
     },
     {
          "icon": "custom-icon soccer",
          "name": "soccer"
     },
     {
          "icon": "custom-icon table-tennis",
          "name": "table-tennis"
     },
     {
          "icon": "custom-icon tennis",
          "name": "tennis"
     },
     {
          "icon": "custom-icon aussie-rules",
          "name": "aussie-rules"
     }
]

ICONS.sort((a, b) => (a.name > b.name ? 1 : -1));

const inputField = document.querySelector('.sportsIcon');
const inputFieldParent = document.querySelector('.sportsIconParent');
let iconWrapper;

inputField.addEventListener("focus", function () {
     let searchField;
     iconWrapper = document.createElement("div");
     iconWrapper.classList.add('icon-wrapper');
     searchField = document.createElement("input");
     searchField.classList.add('form-control', 'search-field');
     searchField.setAttribute('placeholder', 'Search...');
     iconWrapper.appendChild(searchField);
     createIcons(ICONS);
     inputFieldParent.appendChild(iconWrapper);

     searchField.addEventListener('input', function () {
          let searchTerm = this.value;
          if (this.value) {
               iconList = ICONS.filter(item => item.name.toLowerCase().includes(searchTerm.toLowerCase()));
          }
          createIcons(iconList);
          removeIconWrapper();
     });

     removeIconWrapper();
});

function removeIconWrapper() {
     document.addEventListener("click", function (event) {
          if (!iconWrapper.contains(event.target) && event.target !== inputField) {
               iconWrapper.remove();
          }
     });
}

function createIcons(iconList) {
     let iconButton;
     iconContainer = document.createElement("div");
     iconContainer.classList.add('icon-container');

     iconList.forEach(function (element) {
          iconButton = document.createElement("button");
          iconButton.setAttribute("type", "button");
          iconButton.innerHTML = `<i class="${element.icon}"></i> <span class="icon-name">${element.name}</span>`;

          iconButton.addEventListener('click', function () {
               console.dir(this.children[0]);
               inputField.value = this.children[0].outerHTML;
          });

          iconContainer.appendChild(iconButton);
     });

     if (iconWrapper.querySelector(".icon-container")) {
          iconWrapper.querySelector(".icon-container").remove()
     }
     iconWrapper.appendChild(iconContainer);

}
